# python-atFunctions is a Python binding of atFunctions

https://darts.isas.jaxa.jp/software/python-atFunctions/

## Prerequriements

- Heasoft
- Python
    - numpy
    - Cython

## Install

### Build

```console
python setup.py build_ext
```

### Test

```console
python setup.py build_ext --inplace
python test.py
```

### Install

```console
pip install .
```

### Example

```
import numpy as np
import atFunctions as pyat
import os

mjd = np.random.rand(10) * 1000 + 58000
pyat.atMissionTimeInit(os.path.join(os.environ['HEADAS'], 'refdata', 'leapsec.fits'))
mission = pyat.atMJDToMission(pyat.optional.MAXI_MJD_BASE, mjd)
print(mission)
```
