from setuptools import Extension, setup, find_packages
from Cython.Build import cythonize
from Cython.Distutils import build_ext
import numpy
import os, platform

if 'HEADAS' not in os.environ:
    raise AttributeError("HEADAS environment variable required")
headas = os.environ['HEADAS']
headas_lib = os.path.join(headas, 'lib')
headas_inc = os.path.join(headas, 'include')
if platform.system() == 'Darwin':
    if 'LDFLAGS' in os.environ:
        os.environ['LDFLAGS'] = os.environ['LDFLAGS'] + ' ' + '-rpath ' + headas_lib
    else:
        os.environ['LDFLAGS'] = '-rpath ' + headas_lib
module1 = Extension(
    "atFunctions.atFunctions",
    sources=['atFunctions/atFunctions.pyx'],
    include_dirs=[headas_inc, numpy.get_include()],
    library_dirs=[headas_lib],
    libraries=['atFunctions', 'cfitsio', 'ncurses'],
)

setup(
    name='python-atFunctions',
    version='0.3.0',
    install_requires=[
        'numpy',
    ],
    packages=find_packages(),
    description='Python binding of atFunctions',
    # url='',
    author='C-SODA ISAS/JAXA',
    # author_email='',
    cmdclass={'build_ext': build_ext},
    ext_modules=[module1],
)
